/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.client.UploadStatus;
import com.mojang.realmsclient.dto.UploadInfo;
import com.mojang.realmsclient.gui.screens.UploadResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.util.Session;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUpload {
    private static final Logger field_224883_a = LogManager.getLogger();
    private final File field_224884_b;
    private final long field_224885_c;
    private final int field_224886_d;
    private final UploadInfo field_224887_e;
    private final String field_224888_f;
    private final String field_224889_g;
    private final String field_224890_h;
    private final UploadStatus field_224891_i;
    private final AtomicBoolean field_224892_j = new AtomicBoolean(false);
    private CompletableFuture<UploadResult> field_224893_k;
    private final RequestConfig field_224894_l = RequestConfig.custom().setSocketTimeout((int)TimeUnit.MINUTES.toMillis(10L)).setConnectTimeout((int)TimeUnit.SECONDS.toMillis(15L)).build();

    public FileUpload(File file, long l, int n, UploadInfo uploadInfo, Session session, String string, UploadStatus uploadStatus) {
        this.field_224884_b = file;
        this.field_224885_c = l;
        this.field_224886_d = n;
        this.field_224887_e = uploadInfo;
        this.field_224888_f = session.func_111286_b();
        this.field_224889_g = session.func_111285_a();
        this.field_224890_h = string;
        this.field_224891_i = uploadStatus;
    }

    public void func_224874_a(Consumer<UploadResult> consumer) {
        if (this.field_224893_k != null) {
            return;
        }
        this.field_224893_k = CompletableFuture.supplyAsync(() -> this.func_224879_a(0));
        this.field_224893_k.thenAccept((Consumer)consumer);
    }

    public void func_224878_a() {
        this.field_224892_j.set(true);
        if (this.field_224893_k != null) {
            this.field_224893_k.cancel(false);
            this.field_224893_k = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult func_224879_a(int n) {
        UploadResult.Builder builder = new UploadResult.Builder();
        if (this.field_224892_j.get()) {
            return builder.func_225174_a();
        }
        this.field_224891_i.field_224979_b = this.field_224884_b.length();
        HttpPost \u26032 = new HttpPost(this.field_224887_e.func_243089_b().resolve("/upload/" + this.field_224885_c + "/" + this.field_224886_d));
        CloseableHttpClient \u26033 = HttpClientBuilder.create().setDefaultRequestConfig(this.field_224894_l).build();
        try {
            this.func_224872_a(\u26032);
            CloseableHttpResponse closeableHttpResponse = \u26033.execute((HttpUriRequest)\u26032);
            long \u26034 = this.func_224880_a((HttpResponse)closeableHttpResponse);
            if (this.func_224882_a(\u26034, n)) {
                UploadResult uploadResult = this.func_224876_b(\u26034, n);
                return uploadResult;
            }
            this.func_224875_a((HttpResponse)closeableHttpResponse, builder);
        }
        catch (Exception exception) {
            if (!this.field_224892_j.get()) {
                field_224883_a.error("Caught exception while uploading: ", (Throwable)exception);
            }
        }
        finally {
            this.func_224877_a(\u26032, \u26033);
        }
        return builder.func_225174_a();
    }

    private void func_224877_a(HttpPost httpPost, CloseableHttpClient closeableHttpClient) {
        httpPost.releaseConnection();
        if (closeableHttpClient != null) {
            try {
                closeableHttpClient.close();
            }
            catch (IOException iOException) {
                field_224883_a.error("Failed to close Realms upload client");
            }
        }
    }

    private void func_224872_a(HttpPost httpPost) throws FileNotFoundException {
        httpPost.setHeader("Cookie", "sid=" + this.field_224888_f + ";token=" + this.field_224887_e.func_230795_a_() + ";user=" + this.field_224889_g + ";version=" + this.field_224890_h);
        CustomInputStreamEntity customInputStreamEntity = new CustomInputStreamEntity(new FileInputStream(this.field_224884_b), this.field_224884_b.length(), this.field_224891_i);
        customInputStreamEntity.setContentType("application/octet-stream");
        httpPost.setEntity((HttpEntity)customInputStreamEntity);
    }

    private void func_224875_a(HttpResponse httpResponse, UploadResult.Builder builder) throws IOException {
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n == 401) {
            field_224883_a.debug("Realms server returned 401: " + httpResponse.getFirstHeader("WWW-Authenticate"));
        }
        builder.func_225175_a(n);
        if (httpResponse.getEntity() != null && (\u2603 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8")) != null) {
            try {
                JsonParser jsonParser = new JsonParser();
                JsonElement \u26032 = jsonParser.parse(\u2603).getAsJsonObject().get("errorMsg");
                Optional<String> \u26033 = Optional.ofNullable(\u26032).map(JsonElement::getAsString);
                builder.func_225176_a(\u26033.orElse(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean func_224882_a(long l, int n) {
        return l > 0L && n + 1 < 5;
    }

    private UploadResult func_224876_b(long l, int n) throws InterruptedException {
        Thread.sleep(Duration.ofSeconds(l).toMillis());
        return this.func_224879_a(n + 1);
    }

    private long func_224880_a(HttpResponse httpResponse) {
        return Optional.ofNullable(httpResponse.getFirstHeader("Retry-After")).map(Header::getValue).map(Long::valueOf).orElse(0L);
    }

    public boolean func_224881_b() {
        return this.field_224893_k.isDone() || this.field_224893_k.isCancelled();
    }

    static class CustomInputStreamEntity
    extends InputStreamEntity {
        private final long field_224869_a;
        private final InputStream field_224870_b;
        private final UploadStatus field_224871_c;

        public CustomInputStreamEntity(InputStream inputStream, long l, UploadStatus uploadStatus) {
            super(inputStream);
            this.field_224870_b = inputStream;
            this.field_224869_a = l;
            this.field_224871_c = uploadStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outputStream) throws IOException {
            block7: {
                Args.notNull((Object)outputStream, (String)"Output stream");
                try (InputStream inputStream = this.field_224870_b;){
                    byte[] byArray = new byte[4096];
                    if (this.field_224869_a < 0L) {
                        while ((\u2603 = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, \u2603);
                            this.field_224871_c.field_224978_a += (long)\u2603;
                        }
                        break block7;
                    }
                    for (long i = this.field_224869_a; i > 0L; i -= (long)n) {
                        int n = inputStream.read(byArray, 0, (int)Math.min(4096L, i));
                        if (n == -1) {
                            break;
                        }
                        outputStream.write(byArray, 0, n);
                        this.field_224871_c.field_224978_a += (long)n;
                        outputStream.flush();
                    }
                }
            }
        }
    }
}

